/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.SyntacticTreeShell;
import net.nooj4nlp.gui.shells.TextEditorShell;
import net.nooj4nlp.gui.utilities.Helper;

public class ConcordanceMouseActionListener
extends MouseAdapter {
    private ConcordanceShellController controller;
    private TextEditorShellController textController;
    private JTable concordanceTable;

    public ConcordanceMouseActionListener(ConcordanceShellController controller) {
        this.controller = controller;
        this.concordanceTable = this.controller.getConcordanceTable();
        this.textController = this.controller.getTextController();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            ArrayList annotations;
            if (this.concordanceTable.getSelectedRowCount() < 1) {
                return;
            }
            List<Object> theItems = this.controller.getTheItems();
            int selectedRow = this.concordanceTable.getSelectedRow();
            Object[] item = new Object[6];
            DefaultTableModel tableModel = (DefaultTableModel)this.concordanceTable.getModel();
            Object fifth = tableModel.getValueAt(selectedRow, 4);
            Object sixth = tableModel.getValueAt(selectedRow, 5);
            for (int i = 0; i < theItems.size(); i += 4) {
                Object[] tempItem = (Object[])theItems.get(i + 1);
                if (this.controller.getColorMap().get(tempItem[4]) != (Integer)fifth || !sixth.equals(tempItem[5])) continue;
                item = tempItem;
                break;
            }
            if ((annotations = (ArrayList)item[5]) == null) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Annotations are empty!", "NooJ Error!", 0);
                return;
            }
            double absoluteBeginAddress0 = (Double)annotations.get(2);
            int absoluteBeginAddress = (int)absoluteBeginAddress0;
            this.textController.getTextShell().getTextPane().setCaretPosition(absoluteBeginAddress);
            TextEditorShell textShell = this.textController.getTextShell();
            Helper.putDialogOnTheTop(textShell);
            if (this.controller.getSyntacticTreeShell() != null) {
                SyntacticTreeShell syntacticTree = this.controller.getSyntacticTreeShell();
                syntacticTree.getController().setConcordanceIndex(this.controller.getConcordanceShell().getConcordanceTable().getSelectedRow());
                syntacticTree.setVisible(true);
                syntacticTree.invalidate();
                syntacticTree.validate();
                syntacticTree.repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Component component = e.getComponent();
        CursorChangeEffect.setCrossCursor(component);
    }
}

